#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */

#include "rtc_driver_ext.h"

void isr_callback(unsigned int interrupt_mask, unsigned char tamper_mask)
{
  return;
}
 /*Global variables decraled */
  unsigned int y;
  enum month_names m;
  unsigned char dat;
  enum weekday_names wday;
  unsigned char hr, mnts, secs;

void main(void) {

  SOPT1_COPT = 0;   /* Cop watch dog disabled*/
  EnableInterrupts; /* enable interrupts */
  

  /* Sample Code starts*/
  
  /*Configures the RTC*/
  (void)rtc_setConfig(RTC_CLKOUT_1HZ, RTC_DAYLIGHTSAVINGS_DISABLE, 0, &isr_callback);

  /*sets the compensation window*/
  rtc_setCompensation(20, 28);

  /*Sets the date and time*/
  if(!rtc_setDateAndTime(2010, December, 3, Thursday, 15, 30, 30))
  {
    //success
  }
  
  
  y = rtc_getYear();   //gets back the year 
  m = rtc_getMonth();  //reads back the month
  rtc_getDayAndDate(&wday, &dat); //reads back the day and date
  hr = (unsigned char)rtc_getHour(); //reads back the hour
  mnts = (unsigned char)rtc_getMin(); //reads back the minutes
  secs = (unsigned char)rtc_getSeconds(); //reads back the secs
  
  /* Sets the alarm */
  if(!rtc_setAlarm(2010, June, 20, 12, 41, 45))
  {
    //success
  }
  
  y = rtc_getAlarmYear();
  m = (enum month_names)rtc_getAlarmMonth();
  dat = (unsigned char)rtc_getAlarmDate();
  hr = (unsigned char)rtc_getAlarmHour();
  mnts = (unsigned char)rtc_getAlarmMin();
  secs = (unsigned char)rtc_getAlarmSeconds();
  
  for(;;) {
    __RESET_WATCHDOG(); /* feeds the dog */
  } /* loop forever */
  /* please make sure that you never leave main */
}
